---
title: Document Format Conventions
author: NVIDIA
weight: 11500
toc: 3
---

The NetQ documentation uses the following typographical and note conventions.

## Typographical Conventions

Throughout the guide, text formatting is used to convey contextual information about the content.

| Text Format  | Meaning |
| --------------- | ----------- |
| <span style="color: #00ad69;"> Green text </span> | Link to additional content within the topic or to another topic |
| `Text in Monospace font` |  Filename, directory and path names, and command usage |
| \[`Text within square brackets`\] | Optional command parameters; may be presented in mixed case or all caps text |
| \<`Text within angle brackets`\> | Required command parameter values-variables that are to be replaced with a relevant value; may be presented in mixed case or all caps text |

## Note Conventions

Several note types are used throughout the document. The formatting of the note indicates its intent and
urgency.

{{<notice tip>}}
Offers information to improve your experience with the tool, such as time-saving or shortcut options, or indicates the common or recommended method for performing a particular task or process
{{</notice>}}

{{<notice note>}}
Provides additional information or a reminder about a task or process that may impact your next step or selection
{{</notice>}}

{{<notice info>}}
Advises that failure to take or avoid specific action can result in possible data loss
{{</notice>}}

{{<notice warning>}}
Advises that failure to take or avoid specific action can result in possible physical harm to yourself, hardware equipment, or facility
{{</notice>}}
